/************ 
 * Iat Test *
 ************/

import { core, data, sound, util, visual } from './lib/psychojs-2021.2.3.js';
const { PsychoJS } = core;
const { TrialHandler } = data;
const { Scheduler } = util;
//some handy aliases as in the psychopy scripts;
const { abs, sin, cos, PI: pi, sqrt } = Math;
const { round } = util;


// store info about the experiment session:
let expName = 'IAT';  // from the Builder filename that created this script
let expInfo = {'': ''};

// Start code blocks for 'Before Experiment'
// init psychoJS:
const psychoJS = new PsychoJS({
  debug: true
});

// open window:
psychoJS.openWindow({
  fullscr: true,
  color: new util.Color([1, 1, 1]),
  units: 'height',
  waitBlanking: true
});
// schedule the experiment:
psychoJS.schedule(psychoJS.gui.DlgFromDict({
  dictionary: expInfo,
  title: expName
}));

const flowScheduler = new Scheduler(psychoJS);
const dialogCancelScheduler = new Scheduler(psychoJS);
psychoJS.scheduleCondition(function() { return (psychoJS.gui.dialogComponent.button === 'OK'); }, flowScheduler, dialogCancelScheduler);

// flowScheduler gets run if the participants presses OK
flowScheduler.add(updateInfo); // add timeStamp
flowScheduler.add(experimentInit);
flowScheduler.add(instruction1RoutineBegin());
flowScheduler.add(instruction1RoutineEachFrame());
flowScheduler.add(instruction1RoutineEnd());
flowScheduler.add(insttruction123RoutineBegin());
flowScheduler.add(insttruction123RoutineEachFrame());
flowScheduler.add(insttruction123RoutineEnd());
flowScheduler.add(instruction213RoutineBegin());
flowScheduler.add(instruction213RoutineEachFrame());
flowScheduler.add(instruction213RoutineEnd());
flowScheduler.add(instruction321RoutineBegin());
flowScheduler.add(instruction321RoutineEachFrame());
flowScheduler.add(instruction321RoutineEnd());
flowScheduler.add(INSRoutineBegin());
flowScheduler.add(INSRoutineEachFrame());
flowScheduler.add(INSRoutineEnd());
flowScheduler.add(ins5RoutineBegin());
flowScheduler.add(ins5RoutineEachFrame());
flowScheduler.add(ins5RoutineEnd());
flowScheduler.add(ins6RoutineBegin());
flowScheduler.add(ins6RoutineEachFrame());
flowScheduler.add(ins6RoutineEnd());
flowScheduler.add(instruction444RoutineBegin());
flowScheduler.add(instruction444RoutineEachFrame());
flowScheduler.add(instruction444RoutineEnd());
const loop1LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop1LoopBegin(loop1LoopScheduler));
flowScheduler.add(loop1LoopScheduler);
flowScheduler.add(loop1LoopEnd);
flowScheduler.add(instruction2RoutineBegin());
flowScheduler.add(instruction2RoutineEachFrame());
flowScheduler.add(instruction2RoutineEnd());
const loop2LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop2LoopBegin(loop2LoopScheduler));
flowScheduler.add(loop2LoopScheduler);
flowScheduler.add(loop2LoopEnd);
flowScheduler.add(instruction3RoutineBegin());
flowScheduler.add(instruction3RoutineEachFrame());
flowScheduler.add(instruction3RoutineEnd());
const loop3LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop3LoopBegin(loop3LoopScheduler));
flowScheduler.add(loop3LoopScheduler);
flowScheduler.add(loop3LoopEnd);
flowScheduler.add(instruction4RoutineBegin());
flowScheduler.add(instruction4RoutineEachFrame());
flowScheduler.add(instruction4RoutineEnd());
const loop4LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop4LoopBegin(loop4LoopScheduler));
flowScheduler.add(loop4LoopScheduler);
flowScheduler.add(loop4LoopEnd);
flowScheduler.add(instroduction5RoutineBegin());
flowScheduler.add(instroduction5RoutineEachFrame());
flowScheduler.add(instroduction5RoutineEnd());
const loop5LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop5LoopBegin(loop5LoopScheduler));
flowScheduler.add(loop5LoopScheduler);
flowScheduler.add(loop5LoopEnd);
flowScheduler.add(instruction6RoutineBegin());
flowScheduler.add(instruction6RoutineEachFrame());
flowScheduler.add(instruction6RoutineEnd());
const loop6LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop6LoopBegin(loop6LoopScheduler));
flowScheduler.add(loop6LoopScheduler);
flowScheduler.add(loop6LoopEnd);
flowScheduler.add(instruction7RoutineBegin());
flowScheduler.add(instruction7RoutineEachFrame());
flowScheduler.add(instruction7RoutineEnd());
const loop7LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(loop7LoopBegin(loop7LoopScheduler));
flowScheduler.add(loop7LoopScheduler);
flowScheduler.add(loop7LoopEnd);
flowScheduler.add(thanksRoutineBegin());
flowScheduler.add(thanksRoutineEachFrame());
flowScheduler.add(thanksRoutineEnd());
flowScheduler.add(quitPsychoJS, '', true);

// quit if user presses Cancel in dialog box:
dialogCancelScheduler.add(quitPsychoJS, '', false);

psychoJS.start({
  expName: expName,
  expInfo: expInfo,
  resources: [
    {'name': 'IAT_block6.xlsx', 'path': 'IAT_block6.xlsx'},
    {'name': 'end.png', 'path': 'end.png'},
    {'name': 'IAT_block2.xlsx', 'path': 'IAT_block2.xlsx'},
    {'name': 'pre7.png', 'path': 'pre7.png'},
    {'name': 'pre6.png', 'path': 'pre6.png'},
    {'name': 'block444.png', 'path': 'block444.png'},
    {'name': 'block333.png', 'path': 'block333.png'},
    {'name': 'block666.png', 'path': 'block666.png'},
    {'name': 'block555.png', 'path': 'block555.png'},
    {'name': 'IAT_block3.xlsx', 'path': 'IAT_block3.xlsx'},
    {'name': 'IAT_block5.xlsx', 'path': 'IAT_block5.xlsx'},
    {'name': 'pre1.png', 'path': 'pre1.png'},
    {'name': 'IAT_block1.xlsx', 'path': 'IAT_block1.xlsx'},
    {'name': 'block777.png', 'path': 'block777.png'},
    {'name': 'pre4.png', 'path': 'pre4.png'},
    {'name': 'pre2.png', 'path': 'pre2.png'},
    {'name': 'block111.png', 'path': 'block111.png'},
    {'name': 'IAT_block7.xlsx', 'path': 'IAT_block7.xlsx'},
    {'name': 'pre5.png', 'path': 'pre5.png'},
    {'name': 'pre3.png', 'path': 'pre3.png'},
    {'name': 'block222.png', 'path': 'block222.png'},
    {'name': 'IAT_block4.xlsx', 'path': 'IAT_block4.xlsx'}
  ]
});

psychoJS.experimentLogger.setLevel(core.Logger.ServerLevel.EXP);


var frameDur;
async function updateInfo() {
  expInfo['date'] = util.MonotonicClock.getDateStr();  // add a simple timestamp
  expInfo['expName'] = expName;
  expInfo['psychopyVersion'] = '2021.2.3';
  expInfo['OS'] = window.navigator.platform;

  // store frame rate of monitor if we can measure it successfully
  expInfo['frameRate'] = psychoJS.window.getActualFrameRate();
  if (typeof expInfo['frameRate'] !== 'undefined')
    frameDur = 1.0 / Math.round(expInfo['frameRate']);
  else
    frameDur = 1.0 / 60.0; // couldn't get a reliable measure so guess

  // add info from the URL:
  util.addInfoFromUrl(expInfo);
  
  return Scheduler.Event.NEXT;
}


var instruction1Clock;
var image1;
var key_resp;
var insttruction123Clock;
var image222_2;
var key_resp_17;
var instruction213Clock;
var image333_2;
var key_resp_18;
var instruction321Clock;
var image999;
var key_resp_15;
var INSClock;
var image;
var key_resp_19;
var ins5Clock;
var image_2;
var key_resp_20;
var ins6Clock;
var image_3;
var key_resp_21;
var instruction444Clock;
var image_8;
var key_resp_16;
var trialsyundong1Clock;
var fixation;
var text_3;
var key_resp_2;
var sportmale;
var sportfemale;
var restart_trial1Clock;
var feedback1Clock;
var feedback_text;
var text1;
var instruction2Clock;
var image2;
var key_resp_9;
var trialface1Clock;
var fixation_2;
var stims2;
var key_resp_3;
var malename;
var femalename;
var restart_trial2Clock;
var feedback2Clock;
var text2;
var instruction3Clock;
var image3;
var key_resp_10;
var trialsprac1Clock;
var fixation3;
var stims3;
var key_resp_4;
var mm1;
var FF1;
var restart_trial3Clock;
var feedback3Clock;
var text2_2;
var instruction4Clock;
var image4;
var key_resp_11;
var trialszs1Clock;
var fixation4;
var stims4;
var key_resp_5;
var mm1_2;
var FF1_2;
var instroduction5Clock;
var image5;
var key_resp_12;
var reialsyundong2Clock;
var fixation5;
var stims5;
var key_resp_6;
var sportfemale2;
var sportmale2;
var restart_5Clock;
var feedback5Clock;
var text2_4;
var instruction6Clock;
var image6;
var key_resp_13;
var trialspr2Clock;
var fixation6;
var stims6;
var key_resp_7;
var FM;
var MF;
var restart_trial6Clock;
var feedback6Clock;
var text2_5;
var instruction7Clock;
var image7;
var key_resp_14;
var trialszs2Clock;
var fixation7;
var stims7;
var key_resp_8;
var FM_2;
var MF_2;
var thanksClock;
var imageend;
var globalClock;
var routineTimer;
async function experimentInit() {
  // Initialize components for Routine "instruction1"
  instruction1Clock = new util.Clock();
  image1 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image1', units : undefined, 
    image : 'pre1.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.8392],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "insttruction123"
  insttruction123Clock = new util.Clock();
  image222_2 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image222_2', units : undefined, 
    image : 'pre2.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.8365],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_17 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "instruction213"
  instruction213Clock = new util.Clock();
  image333_2 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image333_2', units : undefined, 
    image : 'pre3.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_18 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "instruction321"
  instruction321Clock = new util.Clock();
  image999 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image999', units : undefined, 
    image : 'pre4.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_15 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "INS"
  INSClock = new util.Clock();
  image = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image', units : undefined, 
    image : 'pre5.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_19 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "ins5"
  ins5Clock = new util.Clock();
  image_2 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image_2', units : undefined, 
    image : 'pre6.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_20 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "ins6"
  ins6Clock = new util.Clock();
  image_3 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image_3', units : undefined, 
    image : 'pre7.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_21 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "instruction444"
  instruction444Clock = new util.Clock();
  image_8 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image_8', units : undefined, 
    image : 'block111.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_16 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialsyundong1"
  trialsyundong1Clock = new util.Clock();
  fixation = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  text_3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_3',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_2 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  sportmale = new visual.TextStim({
    win: psychoJS.window,
    name: 'sportmale',
    text: '发型与人名一致（E）',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  sportfemale = new visual.TextStim({
    win: psychoJS.window,
    name: 'sportfemale',
    text: '发型与人名不一致 （I）',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "restart_trial1"
  restart_trial1Clock = new util.Clock();
  // Initialize components for Routine "feedback1"
  feedback1Clock = new util.Clock();
  feedback_text = "";
  
  text1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text1',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  // Initialize components for Routine "instruction2"
  instruction2Clock = new util.Clock();
  image2 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image2', units : undefined, 
    image : 'block222.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_9 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialface1"
  trialface1Clock = new util.Clock();
  fixation_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation_2',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims2',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_3 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  malename = new visual.TextStim({
    win: psychoJS.window,
    name: 'malename',
    text: '能力词（E）',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  femalename = new visual.TextStim({
    win: psychoJS.window,
    name: 'femalename',
    text: '热情词（I）',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "restart_trial2"
  restart_trial2Clock = new util.Clock();
  // Initialize components for Routine "feedback2"
  feedback2Clock = new util.Clock();
  feedback_text = "";
  
  text2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text2',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  // Initialize components for Routine "instruction3"
  instruction3Clock = new util.Clock();
  image3 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image3', units : undefined, 
    image : 'block333.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_10 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialsprac1"
  trialsprac1Clock = new util.Clock();
  fixation3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation3',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims3',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_4 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  mm1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'mm1',
    text: '发型与人名一致\n能力词',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  FF1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'FF1',
    text: '发型与人名不一致\n热情词',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "restart_trial3"
  restart_trial3Clock = new util.Clock();
  // Initialize components for Routine "feedback3"
  feedback3Clock = new util.Clock();
  feedback_text = "";
  
  text2_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text2_2',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  // Initialize components for Routine "instruction4"
  instruction4Clock = new util.Clock();
  image4 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image4', units : undefined, 
    image : 'block444.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_11 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialszs1"
  trialszs1Clock = new util.Clock();
  fixation4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation4',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims4',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_5 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  mm1_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'mm1_2',
    text: '发型与人名一致\n能力词',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  FF1_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'FF1_2',
    text: '发型与人名不一致\n热情词',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "instroduction5"
  instroduction5Clock = new util.Clock();
  image5 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image5', units : undefined, 
    image : 'block555.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_12 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "reialsyundong2"
  reialsyundong2Clock = new util.Clock();
  fixation5 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation5',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims5 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims5',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_6 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  sportfemale2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'sportfemale2',
    text: '发型与人名不一致',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  sportmale2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'sportmale2',
    text: '发型与人名一致',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "restart_5"
  restart_5Clock = new util.Clock();
  // Initialize components for Routine "feedback5"
  feedback5Clock = new util.Clock();
  feedback_text = "";
  
  text2_4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text2_4',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  // Initialize components for Routine "instruction6"
  instruction6Clock = new util.Clock();
  image6 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image6', units : undefined, 
    image : 'block666.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_13 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialspr2"
  trialspr2Clock = new util.Clock();
  fixation6 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation6',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims6 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims6',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_7 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  FM = new visual.TextStim({
    win: psychoJS.window,
    name: 'FM',
    text: '发型与人名不一致\n能力词',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  MF = new visual.TextStim({
    win: psychoJS.window,
    name: 'MF',
    text: '发型与人名一致\n热情词',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "restart_trial6"
  restart_trial6Clock = new util.Clock();
  // Initialize components for Routine "feedback6"
  feedback6Clock = new util.Clock();
  feedback_text = "";
  
  text2_5 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text2_5',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  // Initialize components for Routine "instruction7"
  instruction7Clock = new util.Clock();
  image7 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'image7', units : undefined, 
    image : 'block777.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  key_resp_14 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "trialszs2"
  trialszs2Clock = new util.Clock();
  fixation7 = new visual.TextStim({
    win: psychoJS.window,
    name: 'fixation7',
    text: '＋',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: 0.0 
  });
  
  stims7 = new visual.TextStim({
    win: psychoJS.window,
    name: 'stims7',
    text: '',
    font: 'Open Sans',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -1.0 
  });
  
  key_resp_8 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  FM_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'FM_2',
    text: '发型与人名不一致\n能力词',
    font: 'Open Sans',
    units: undefined, 
    pos: [(- 0.45), 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -3.0 
  });
  
  MF_2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'MF_2',
    text: '发型与人名一致\n热情词',
    font: 'Open Sans',
    units: undefined, 
    pos: [0.45, 0.35], height: 0.05,  wrapWidth: undefined, ori: 0.0,
    color: new util.Color('black'),  opacity: undefined,
    depth: -4.0 
  });
  
  // Initialize components for Routine "thanks"
  thanksClock = new util.Clock();
  imageend = new visual.ImageStim({
    win : psychoJS.window,
    name : 'imageend', units : undefined, 
    image : 'end.png', mask : undefined,
    ori : 0.0, pos : [0, 0], size : [1.5, 0.9375],
    color : new util.Color([1, 1, 1]), opacity : undefined,
    flipHoriz : false, flipVert : false,
    texRes : 128.0, interpolate : true, depth : 0.0 
  });
  // Create some handy timers
  globalClock = new util.Clock();  // to track the time since experiment started
  routineTimer = new util.CountdownTimer();  // to track time remaining of each (non-slip) routine
  
  return Scheduler.Event.NEXT;
}


var t;
var frameN;
var continueRoutine;
var _key_resp_allKeys;
var instruction1Components;
function instruction1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction1'-------
    t = 0;
    instruction1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp.keys = undefined;
    key_resp.rt = undefined;
    _key_resp_allKeys = [];
    // keep track of which components have finished
    instruction1Components = [];
    instruction1Components.push(image1);
    instruction1Components.push(key_resp);
    
    for (const thisComponent of instruction1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction1'-------
    // get current time
    t = instruction1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image1* updates
    if (t >= 0.0 && image1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image1.tStart = t;  // (not accounting for frame time here)
      image1.frameNStart = frameN;  // exact frame index
      
      image1.setAutoDraw(true);
    }

    
    // *key_resp* updates
    if (t >= 0.0 && key_resp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp.tStart = t;  // (not accounting for frame time here)
      key_resp.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp.clearEvents(); });
    }

    if (key_resp.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_allKeys = _key_resp_allKeys.concat(theseKeys);
      if (_key_resp_allKeys.length > 0) {
        key_resp.keys = _key_resp_allKeys[_key_resp_allKeys.length - 1].name;  // just the last key pressed
        key_resp.rt = _key_resp_allKeys[_key_resp_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction1RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction1'-------
    for (const thisComponent of instruction1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp.keys', key_resp.keys);
    if (typeof key_resp.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp.rt', key_resp.rt);
        routineTimer.reset();
        }
    
    key_resp.stop();
    // the Routine "instruction1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_17_allKeys;
var insttruction123Components;
function insttruction123RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'insttruction123'-------
    t = 0;
    insttruction123Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_17.keys = undefined;
    key_resp_17.rt = undefined;
    _key_resp_17_allKeys = [];
    // keep track of which components have finished
    insttruction123Components = [];
    insttruction123Components.push(image222_2);
    insttruction123Components.push(key_resp_17);
    
    for (const thisComponent of insttruction123Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function insttruction123RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'insttruction123'-------
    // get current time
    t = insttruction123Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image222_2* updates
    if (t >= 0.0 && image222_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image222_2.tStart = t;  // (not accounting for frame time here)
      image222_2.frameNStart = frameN;  // exact frame index
      
      image222_2.setAutoDraw(true);
    }

    
    // *key_resp_17* updates
    if (t >= 0.0 && key_resp_17.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_17.tStart = t;  // (not accounting for frame time here)
      key_resp_17.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_17.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_17.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_17.clearEvents(); });
    }

    if (key_resp_17.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_17.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_17_allKeys = _key_resp_17_allKeys.concat(theseKeys);
      if (_key_resp_17_allKeys.length > 0) {
        key_resp_17.keys = _key_resp_17_allKeys[_key_resp_17_allKeys.length - 1].name;  // just the last key pressed
        key_resp_17.rt = _key_resp_17_allKeys[_key_resp_17_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of insttruction123Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function insttruction123RoutineEnd() {
  return async function () {
    //------Ending Routine 'insttruction123'-------
    for (const thisComponent of insttruction123Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_17.keys', key_resp_17.keys);
    if (typeof key_resp_17.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_17.rt', key_resp_17.rt);
        routineTimer.reset();
        }
    
    key_resp_17.stop();
    // the Routine "insttruction123" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_18_allKeys;
var instruction213Components;
function instruction213RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction213'-------
    t = 0;
    instruction213Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_18.keys = undefined;
    key_resp_18.rt = undefined;
    _key_resp_18_allKeys = [];
    // keep track of which components have finished
    instruction213Components = [];
    instruction213Components.push(image333_2);
    instruction213Components.push(key_resp_18);
    
    for (const thisComponent of instruction213Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction213RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction213'-------
    // get current time
    t = instruction213Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image333_2* updates
    if (t >= 0.0 && image333_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image333_2.tStart = t;  // (not accounting for frame time here)
      image333_2.frameNStart = frameN;  // exact frame index
      
      image333_2.setAutoDraw(true);
    }

    
    // *key_resp_18* updates
    if (t >= 0.0 && key_resp_18.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_18.tStart = t;  // (not accounting for frame time here)
      key_resp_18.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_18.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_18.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_18.clearEvents(); });
    }

    if (key_resp_18.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_18.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_18_allKeys = _key_resp_18_allKeys.concat(theseKeys);
      if (_key_resp_18_allKeys.length > 0) {
        key_resp_18.keys = _key_resp_18_allKeys[_key_resp_18_allKeys.length - 1].name;  // just the last key pressed
        key_resp_18.rt = _key_resp_18_allKeys[_key_resp_18_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction213Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction213RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction213'-------
    for (const thisComponent of instruction213Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_18.keys', key_resp_18.keys);
    if (typeof key_resp_18.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_18.rt', key_resp_18.rt);
        routineTimer.reset();
        }
    
    key_resp_18.stop();
    // the Routine "instruction213" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_15_allKeys;
var instruction321Components;
function instruction321RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction321'-------
    t = 0;
    instruction321Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_15.keys = undefined;
    key_resp_15.rt = undefined;
    _key_resp_15_allKeys = [];
    // keep track of which components have finished
    instruction321Components = [];
    instruction321Components.push(image999);
    instruction321Components.push(key_resp_15);
    
    for (const thisComponent of instruction321Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction321RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction321'-------
    // get current time
    t = instruction321Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image999* updates
    if (t >= 0.0 && image999.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image999.tStart = t;  // (not accounting for frame time here)
      image999.frameNStart = frameN;  // exact frame index
      
      image999.setAutoDraw(true);
    }

    
    // *key_resp_15* updates
    if (t >= 0.0 && key_resp_15.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_15.tStart = t;  // (not accounting for frame time here)
      key_resp_15.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_15.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_15.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_15.clearEvents(); });
    }

    if (key_resp_15.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_15.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_15_allKeys = _key_resp_15_allKeys.concat(theseKeys);
      if (_key_resp_15_allKeys.length > 0) {
        key_resp_15.keys = _key_resp_15_allKeys[_key_resp_15_allKeys.length - 1].name;  // just the last key pressed
        key_resp_15.rt = _key_resp_15_allKeys[_key_resp_15_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction321Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction321RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction321'-------
    for (const thisComponent of instruction321Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_15.keys', key_resp_15.keys);
    if (typeof key_resp_15.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_15.rt', key_resp_15.rt);
        routineTimer.reset();
        }
    
    key_resp_15.stop();
    // the Routine "instruction321" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_19_allKeys;
var INSComponents;
function INSRoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'INS'-------
    t = 0;
    INSClock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_19.keys = undefined;
    key_resp_19.rt = undefined;
    _key_resp_19_allKeys = [];
    // keep track of which components have finished
    INSComponents = [];
    INSComponents.push(image);
    INSComponents.push(key_resp_19);
    
    for (const thisComponent of INSComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function INSRoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'INS'-------
    // get current time
    t = INSClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image* updates
    if (t >= 0.0 && image.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image.tStart = t;  // (not accounting for frame time here)
      image.frameNStart = frameN;  // exact frame index
      
      image.setAutoDraw(true);
    }

    
    // *key_resp_19* updates
    if (t >= 0.0 && key_resp_19.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_19.tStart = t;  // (not accounting for frame time here)
      key_resp_19.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_19.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_19.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_19.clearEvents(); });
    }

    if (key_resp_19.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_19.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_19_allKeys = _key_resp_19_allKeys.concat(theseKeys);
      if (_key_resp_19_allKeys.length > 0) {
        key_resp_19.keys = _key_resp_19_allKeys[_key_resp_19_allKeys.length - 1].name;  // just the last key pressed
        key_resp_19.rt = _key_resp_19_allKeys[_key_resp_19_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of INSComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function INSRoutineEnd() {
  return async function () {
    //------Ending Routine 'INS'-------
    for (const thisComponent of INSComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_19.keys', key_resp_19.keys);
    if (typeof key_resp_19.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_19.rt', key_resp_19.rt);
        routineTimer.reset();
        }
    
    key_resp_19.stop();
    // the Routine "INS" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_20_allKeys;
var ins5Components;
function ins5RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'ins5'-------
    t = 0;
    ins5Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_20.keys = undefined;
    key_resp_20.rt = undefined;
    _key_resp_20_allKeys = [];
    // keep track of which components have finished
    ins5Components = [];
    ins5Components.push(image_2);
    ins5Components.push(key_resp_20);
    
    for (const thisComponent of ins5Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function ins5RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'ins5'-------
    // get current time
    t = ins5Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image_2* updates
    if (t >= 0.0 && image_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image_2.tStart = t;  // (not accounting for frame time here)
      image_2.frameNStart = frameN;  // exact frame index
      
      image_2.setAutoDraw(true);
    }

    
    // *key_resp_20* updates
    if (t >= 0.0 && key_resp_20.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_20.tStart = t;  // (not accounting for frame time here)
      key_resp_20.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_20.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_20.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_20.clearEvents(); });
    }

    if (key_resp_20.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_20.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_20_allKeys = _key_resp_20_allKeys.concat(theseKeys);
      if (_key_resp_20_allKeys.length > 0) {
        key_resp_20.keys = _key_resp_20_allKeys[_key_resp_20_allKeys.length - 1].name;  // just the last key pressed
        key_resp_20.rt = _key_resp_20_allKeys[_key_resp_20_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of ins5Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function ins5RoutineEnd() {
  return async function () {
    //------Ending Routine 'ins5'-------
    for (const thisComponent of ins5Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_20.keys', key_resp_20.keys);
    if (typeof key_resp_20.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_20.rt', key_resp_20.rt);
        routineTimer.reset();
        }
    
    key_resp_20.stop();
    // the Routine "ins5" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_21_allKeys;
var ins6Components;
function ins6RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'ins6'-------
    t = 0;
    ins6Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_21.keys = undefined;
    key_resp_21.rt = undefined;
    _key_resp_21_allKeys = [];
    // keep track of which components have finished
    ins6Components = [];
    ins6Components.push(image_3);
    ins6Components.push(key_resp_21);
    
    for (const thisComponent of ins6Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function ins6RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'ins6'-------
    // get current time
    t = ins6Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image_3* updates
    if (t >= 0.0 && image_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image_3.tStart = t;  // (not accounting for frame time here)
      image_3.frameNStart = frameN;  // exact frame index
      
      image_3.setAutoDraw(true);
    }

    
    // *key_resp_21* updates
    if (t >= 0.0 && key_resp_21.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_21.tStart = t;  // (not accounting for frame time here)
      key_resp_21.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_21.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_21.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_21.clearEvents(); });
    }

    if (key_resp_21.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_21.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_21_allKeys = _key_resp_21_allKeys.concat(theseKeys);
      if (_key_resp_21_allKeys.length > 0) {
        key_resp_21.keys = _key_resp_21_allKeys[_key_resp_21_allKeys.length - 1].name;  // just the last key pressed
        key_resp_21.rt = _key_resp_21_allKeys[_key_resp_21_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of ins6Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function ins6RoutineEnd() {
  return async function () {
    //------Ending Routine 'ins6'-------
    for (const thisComponent of ins6Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_21.keys', key_resp_21.keys);
    if (typeof key_resp_21.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_21.rt', key_resp_21.rt);
        routineTimer.reset();
        }
    
    key_resp_21.stop();
    // the Routine "ins6" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_16_allKeys;
var instruction444Components;
function instruction444RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction444'-------
    t = 0;
    instruction444Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_16.keys = undefined;
    key_resp_16.rt = undefined;
    _key_resp_16_allKeys = [];
    // keep track of which components have finished
    instruction444Components = [];
    instruction444Components.push(image_8);
    instruction444Components.push(key_resp_16);
    
    for (const thisComponent of instruction444Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction444RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction444'-------
    // get current time
    t = instruction444Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image_8* updates
    if (t >= 0.0 && image_8.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image_8.tStart = t;  // (not accounting for frame time here)
      image_8.frameNStart = frameN;  // exact frame index
      
      image_8.setAutoDraw(true);
    }

    
    // *key_resp_16* updates
    if (t >= 0.0 && key_resp_16.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_16.tStart = t;  // (not accounting for frame time here)
      key_resp_16.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_16.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_16.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_16.clearEvents(); });
    }

    if (key_resp_16.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_16.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_16_allKeys = _key_resp_16_allKeys.concat(theseKeys);
      if (_key_resp_16_allKeys.length > 0) {
        key_resp_16.keys = _key_resp_16_allKeys[_key_resp_16_allKeys.length - 1].name;  // just the last key pressed
        key_resp_16.rt = _key_resp_16_allKeys[_key_resp_16_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction444Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction444RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction444'-------
    for (const thisComponent of instruction444Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_16.keys', key_resp_16.keys);
    if (typeof key_resp_16.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_16.rt', key_resp_16.rt);
        routineTimer.reset();
        }
    
    key_resp_16.stop();
    // the Routine "instruction444" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var loop1;
var currentLoop;
function loop1LoopBegin(loop1LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop1 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block1.xlsx',
      seed: undefined, name: 'loop1'
    });
    psychoJS.experiment.addLoop(loop1); // add the loop to the experiment
    currentLoop = loop1;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop1 of loop1) {
      const snapshot = loop1.getSnapshot();
      loop1LoopScheduler.add(importConditions(snapshot));
      const repeatLoop1LoopScheduler = new Scheduler(psychoJS);
      loop1LoopScheduler.add(repeatLoop1LoopBegin(repeatLoop1LoopScheduler, snapshot));
      loop1LoopScheduler.add(repeatLoop1LoopScheduler);
      loop1LoopScheduler.add(repeatLoop1LoopEnd);
      loop1LoopScheduler.add(endLoopIteration(loop1LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


var repeatLoop1;
function repeatLoop1LoopBegin(repeatLoop1LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    repeatLoop1 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 5, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: undefined,
      seed: undefined, name: 'repeatLoop1'
    });
    psychoJS.experiment.addLoop(repeatLoop1); // add the loop to the experiment
    currentLoop = repeatLoop1;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisRepeatLoop1 of repeatLoop1) {
      const snapshot = repeatLoop1.getSnapshot();
      repeatLoop1LoopScheduler.add(importConditions(snapshot));
      repeatLoop1LoopScheduler.add(trialsyundong1RoutineBegin(snapshot));
      repeatLoop1LoopScheduler.add(trialsyundong1RoutineEachFrame());
      repeatLoop1LoopScheduler.add(trialsyundong1RoutineEnd());
      repeatLoop1LoopScheduler.add(restart_trial1RoutineBegin(snapshot));
      repeatLoop1LoopScheduler.add(restart_trial1RoutineEachFrame());
      repeatLoop1LoopScheduler.add(restart_trial1RoutineEnd());
      repeatLoop1LoopScheduler.add(feedback1RoutineBegin(snapshot));
      repeatLoop1LoopScheduler.add(feedback1RoutineEachFrame());
      repeatLoop1LoopScheduler.add(feedback1RoutineEnd());
      repeatLoop1LoopScheduler.add(endLoopIteration(repeatLoop1LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function repeatLoop1LoopEnd() {
  psychoJS.experiment.removeLoop(repeatLoop1);

  return Scheduler.Event.NEXT;
}


async function loop1LoopEnd() {
  psychoJS.experiment.removeLoop(loop1);

  return Scheduler.Event.NEXT;
}


var loop2;
function loop2LoopBegin(loop2LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop2 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block2.xlsx',
      seed: undefined, name: 'loop2'
    });
    psychoJS.experiment.addLoop(loop2); // add the loop to the experiment
    currentLoop = loop2;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop2 of loop2) {
      const snapshot = loop2.getSnapshot();
      loop2LoopScheduler.add(importConditions(snapshot));
      const repeatLoop2LoopScheduler = new Scheduler(psychoJS);
      loop2LoopScheduler.add(repeatLoop2LoopBegin(repeatLoop2LoopScheduler, snapshot));
      loop2LoopScheduler.add(repeatLoop2LoopScheduler);
      loop2LoopScheduler.add(repeatLoop2LoopEnd);
      loop2LoopScheduler.add(endLoopIteration(loop2LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


var repeatLoop2;
function repeatLoop2LoopBegin(repeatLoop2LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    repeatLoop2 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 5, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: undefined,
      seed: undefined, name: 'repeatLoop2'
    });
    psychoJS.experiment.addLoop(repeatLoop2); // add the loop to the experiment
    currentLoop = repeatLoop2;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisRepeatLoop2 of repeatLoop2) {
      const snapshot = repeatLoop2.getSnapshot();
      repeatLoop2LoopScheduler.add(importConditions(snapshot));
      repeatLoop2LoopScheduler.add(trialface1RoutineBegin(snapshot));
      repeatLoop2LoopScheduler.add(trialface1RoutineEachFrame());
      repeatLoop2LoopScheduler.add(trialface1RoutineEnd());
      repeatLoop2LoopScheduler.add(restart_trial2RoutineBegin(snapshot));
      repeatLoop2LoopScheduler.add(restart_trial2RoutineEachFrame());
      repeatLoop2LoopScheduler.add(restart_trial2RoutineEnd());
      repeatLoop2LoopScheduler.add(feedback2RoutineBegin(snapshot));
      repeatLoop2LoopScheduler.add(feedback2RoutineEachFrame());
      repeatLoop2LoopScheduler.add(feedback2RoutineEnd());
      repeatLoop2LoopScheduler.add(endLoopIteration(repeatLoop2LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function repeatLoop2LoopEnd() {
  psychoJS.experiment.removeLoop(repeatLoop2);

  return Scheduler.Event.NEXT;
}


async function loop2LoopEnd() {
  psychoJS.experiment.removeLoop(loop2);

  return Scheduler.Event.NEXT;
}


var loop3;
function loop3LoopBegin(loop3LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop3 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block3.xlsx',
      seed: undefined, name: 'loop3'
    });
    psychoJS.experiment.addLoop(loop3); // add the loop to the experiment
    currentLoop = loop3;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop3 of loop3) {
      const snapshot = loop3.getSnapshot();
      loop3LoopScheduler.add(importConditions(snapshot));
      const repeatLoop3LoopScheduler = new Scheduler(psychoJS);
      loop3LoopScheduler.add(repeatLoop3LoopBegin(repeatLoop3LoopScheduler, snapshot));
      loop3LoopScheduler.add(repeatLoop3LoopScheduler);
      loop3LoopScheduler.add(repeatLoop3LoopEnd);
      loop3LoopScheduler.add(endLoopIteration(loop3LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


var repeatLoop3;
function repeatLoop3LoopBegin(repeatLoop3LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    repeatLoop3 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 5, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: undefined,
      seed: undefined, name: 'repeatLoop3'
    });
    psychoJS.experiment.addLoop(repeatLoop3); // add the loop to the experiment
    currentLoop = repeatLoop3;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisRepeatLoop3 of repeatLoop3) {
      const snapshot = repeatLoop3.getSnapshot();
      repeatLoop3LoopScheduler.add(importConditions(snapshot));
      repeatLoop3LoopScheduler.add(trialsprac1RoutineBegin(snapshot));
      repeatLoop3LoopScheduler.add(trialsprac1RoutineEachFrame());
      repeatLoop3LoopScheduler.add(trialsprac1RoutineEnd());
      repeatLoop3LoopScheduler.add(restart_trial3RoutineBegin(snapshot));
      repeatLoop3LoopScheduler.add(restart_trial3RoutineEachFrame());
      repeatLoop3LoopScheduler.add(restart_trial3RoutineEnd());
      repeatLoop3LoopScheduler.add(feedback3RoutineBegin(snapshot));
      repeatLoop3LoopScheduler.add(feedback3RoutineEachFrame());
      repeatLoop3LoopScheduler.add(feedback3RoutineEnd());
      repeatLoop3LoopScheduler.add(endLoopIteration(repeatLoop3LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function repeatLoop3LoopEnd() {
  psychoJS.experiment.removeLoop(repeatLoop3);

  return Scheduler.Event.NEXT;
}


async function loop3LoopEnd() {
  psychoJS.experiment.removeLoop(loop3);

  return Scheduler.Event.NEXT;
}


var loop4;
function loop4LoopBegin(loop4LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop4 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block4.xlsx',
      seed: undefined, name: 'loop4'
    });
    psychoJS.experiment.addLoop(loop4); // add the loop to the experiment
    currentLoop = loop4;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop4 of loop4) {
      const snapshot = loop4.getSnapshot();
      loop4LoopScheduler.add(importConditions(snapshot));
      loop4LoopScheduler.add(trialszs1RoutineBegin(snapshot));
      loop4LoopScheduler.add(trialszs1RoutineEachFrame());
      loop4LoopScheduler.add(trialszs1RoutineEnd());
      loop4LoopScheduler.add(endLoopIteration(loop4LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function loop4LoopEnd() {
  psychoJS.experiment.removeLoop(loop4);

  return Scheduler.Event.NEXT;
}


var loop5;
function loop5LoopBegin(loop5LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop5 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block5.xlsx',
      seed: undefined, name: 'loop5'
    });
    psychoJS.experiment.addLoop(loop5); // add the loop to the experiment
    currentLoop = loop5;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop5 of loop5) {
      const snapshot = loop5.getSnapshot();
      loop5LoopScheduler.add(importConditions(snapshot));
      const repeatLoop5LoopScheduler = new Scheduler(psychoJS);
      loop5LoopScheduler.add(repeatLoop5LoopBegin(repeatLoop5LoopScheduler, snapshot));
      loop5LoopScheduler.add(repeatLoop5LoopScheduler);
      loop5LoopScheduler.add(repeatLoop5LoopEnd);
      loop5LoopScheduler.add(endLoopIteration(loop5LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


var repeatLoop5;
function repeatLoop5LoopBegin(repeatLoop5LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    repeatLoop5 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 5, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: undefined,
      seed: undefined, name: 'repeatLoop5'
    });
    psychoJS.experiment.addLoop(repeatLoop5); // add the loop to the experiment
    currentLoop = repeatLoop5;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisRepeatLoop5 of repeatLoop5) {
      const snapshot = repeatLoop5.getSnapshot();
      repeatLoop5LoopScheduler.add(importConditions(snapshot));
      repeatLoop5LoopScheduler.add(reialsyundong2RoutineBegin(snapshot));
      repeatLoop5LoopScheduler.add(reialsyundong2RoutineEachFrame());
      repeatLoop5LoopScheduler.add(reialsyundong2RoutineEnd());
      repeatLoop5LoopScheduler.add(restart_5RoutineBegin(snapshot));
      repeatLoop5LoopScheduler.add(restart_5RoutineEachFrame());
      repeatLoop5LoopScheduler.add(restart_5RoutineEnd());
      repeatLoop5LoopScheduler.add(feedback5RoutineBegin(snapshot));
      repeatLoop5LoopScheduler.add(feedback5RoutineEachFrame());
      repeatLoop5LoopScheduler.add(feedback5RoutineEnd());
      repeatLoop5LoopScheduler.add(endLoopIteration(repeatLoop5LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function repeatLoop5LoopEnd() {
  psychoJS.experiment.removeLoop(repeatLoop5);

  return Scheduler.Event.NEXT;
}


async function loop5LoopEnd() {
  psychoJS.experiment.removeLoop(loop5);

  return Scheduler.Event.NEXT;
}


var loop6;
function loop6LoopBegin(loop6LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop6 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block6.xlsx',
      seed: undefined, name: 'loop6'
    });
    psychoJS.experiment.addLoop(loop6); // add the loop to the experiment
    currentLoop = loop6;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop6 of loop6) {
      const snapshot = loop6.getSnapshot();
      loop6LoopScheduler.add(importConditions(snapshot));
      const repeatLoop6LoopScheduler = new Scheduler(psychoJS);
      loop6LoopScheduler.add(repeatLoop6LoopBegin(repeatLoop6LoopScheduler, snapshot));
      loop6LoopScheduler.add(repeatLoop6LoopScheduler);
      loop6LoopScheduler.add(repeatLoop6LoopEnd);
      loop6LoopScheduler.add(endLoopIteration(loop6LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


var repeatLoop6;
function repeatLoop6LoopBegin(repeatLoop6LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    repeatLoop6 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 5, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: undefined,
      seed: undefined, name: 'repeatLoop6'
    });
    psychoJS.experiment.addLoop(repeatLoop6); // add the loop to the experiment
    currentLoop = repeatLoop6;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisRepeatLoop6 of repeatLoop6) {
      const snapshot = repeatLoop6.getSnapshot();
      repeatLoop6LoopScheduler.add(importConditions(snapshot));
      repeatLoop6LoopScheduler.add(trialspr2RoutineBegin(snapshot));
      repeatLoop6LoopScheduler.add(trialspr2RoutineEachFrame());
      repeatLoop6LoopScheduler.add(trialspr2RoutineEnd());
      repeatLoop6LoopScheduler.add(restart_trial6RoutineBegin(snapshot));
      repeatLoop6LoopScheduler.add(restart_trial6RoutineEachFrame());
      repeatLoop6LoopScheduler.add(restart_trial6RoutineEnd());
      repeatLoop6LoopScheduler.add(feedback6RoutineBegin(snapshot));
      repeatLoop6LoopScheduler.add(feedback6RoutineEachFrame());
      repeatLoop6LoopScheduler.add(feedback6RoutineEnd());
      repeatLoop6LoopScheduler.add(endLoopIteration(repeatLoop6LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function repeatLoop6LoopEnd() {
  psychoJS.experiment.removeLoop(repeatLoop6);

  return Scheduler.Event.NEXT;
}


async function loop6LoopEnd() {
  psychoJS.experiment.removeLoop(loop6);

  return Scheduler.Event.NEXT;
}


var loop7;
function loop7LoopBegin(loop7LoopScheduler, snapshot) {
  return async function() {
    TrialHandler.fromSnapshot(snapshot); // update internal variables (.thisN etc) of the loop
    
    // set up handler to look after randomisation of conditions etc
    loop7 = new TrialHandler({
      psychoJS: psychoJS,
      nReps: 2, method: TrialHandler.Method.RANDOM,
      extraInfo: expInfo, originPath: undefined,
      trialList: 'IAT_block7.xlsx',
      seed: undefined, name: 'loop7'
    });
    psychoJS.experiment.addLoop(loop7); // add the loop to the experiment
    currentLoop = loop7;  // we're now the current loop
    
    // Schedule all the trials in the trialList:
    for (const thisLoop7 of loop7) {
      const snapshot = loop7.getSnapshot();
      loop7LoopScheduler.add(importConditions(snapshot));
      loop7LoopScheduler.add(trialszs2RoutineBegin(snapshot));
      loop7LoopScheduler.add(trialszs2RoutineEachFrame());
      loop7LoopScheduler.add(trialszs2RoutineEnd());
      loop7LoopScheduler.add(endLoopIteration(loop7LoopScheduler, snapshot));
    }
    
    return Scheduler.Event.NEXT;
  }
}


async function loop7LoopEnd() {
  psychoJS.experiment.removeLoop(loop7);

  return Scheduler.Event.NEXT;
}


var _key_resp_2_allKeys;
var trialsyundong1Components;
function trialsyundong1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialsyundong1'-------
    t = 0;
    trialsyundong1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    text_3.setText(stims11);
    key_resp_2.keys = undefined;
    key_resp_2.rt = undefined;
    _key_resp_2_allKeys = [];
    // keep track of which components have finished
    trialsyundong1Components = [];
    trialsyundong1Components.push(fixation);
    trialsyundong1Components.push(text_3);
    trialsyundong1Components.push(key_resp_2);
    trialsyundong1Components.push(sportmale);
    trialsyundong1Components.push(sportfemale);
    
    for (const thisComponent of trialsyundong1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


var frameRemains;
function trialsyundong1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialsyundong1'-------
    // get current time
    t = trialsyundong1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation* updates
    if (t >= 0.0 && fixation.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation.tStart = t;  // (not accounting for frame time here)
      fixation.frameNStart = frameN;  // exact frame index
      
      fixation.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation.setAutoDraw(false);
    }
    
    // *text_3* updates
    if (t >= 0.5 && text_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_3.tStart = t;  // (not accounting for frame time here)
      text_3.frameNStart = frameN;  // exact frame index
      
      text_3.setAutoDraw(true);
    }

    
    // *key_resp_2* updates
    if (t >= 0.5 && key_resp_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_2.tStart = t;  // (not accounting for frame time here)
      key_resp_2.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_2.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_2.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_2.clearEvents(); });
    }

    if (key_resp_2.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_2.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_2_allKeys = _key_resp_2_allKeys.concat(theseKeys);
      if (_key_resp_2_allKeys.length > 0) {
        key_resp_2.keys = _key_resp_2_allKeys[_key_resp_2_allKeys.length - 1].name;  // just the last key pressed
        key_resp_2.rt = _key_resp_2_allKeys[_key_resp_2_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_2.keys == correct_key1) {
            key_resp_2.corr = 1;
        } else {
            key_resp_2.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *sportmale* updates
    if (t >= 0.0 && sportmale.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sportmale.tStart = t;  // (not accounting for frame time here)
      sportmale.frameNStart = frameN;  // exact frame index
      
      sportmale.setAutoDraw(true);
    }

    
    // *sportfemale* updates
    if (t >= 0.0 && sportfemale.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sportfemale.tStart = t;  // (not accounting for frame time here)
      sportfemale.frameNStart = frameN;  // exact frame index
      
      sportfemale.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialsyundong1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialsyundong1RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialsyundong1'-------
    for (const thisComponent of trialsyundong1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_2.keys === undefined) {
      if (['None','none',undefined].includes(correct_key1)) {
         key_resp_2.corr = 1;  // correct non-response
      } else {
         key_resp_2.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_2.keys', key_resp_2.keys);
    psychoJS.experiment.addData('key_resp_2.corr', key_resp_2.corr);
    if (typeof key_resp_2.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_2.rt', key_resp_2.rt);
        routineTimer.reset();
        }
    
    key_resp_2.stop();
    // the Routine "trialsyundong1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var restart_trial1Components;
function restart_trial1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'restart_trial1'-------
    t = 0;
    restart_trial1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    if ((key_resp_2.corr === 0)) {
        repeatLoop1.finished = false;
    } else {
        repeatLoop1.finished = true;
    }
    
    // keep track of which components have finished
    restart_trial1Components = [];
    
    for (const thisComponent of restart_trial1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function restart_trial1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'restart_trial1'-------
    // get current time
    t = restart_trial1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of restart_trial1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function restart_trial1RoutineEnd() {
  return async function () {
    //------Ending Routine 'restart_trial1'-------
    for (const thisComponent of restart_trial1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "restart_trial1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var feedback1Components;
function feedback1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'feedback1'-------
    t = 0;
    feedback1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(1.000000);
    // update component parameters for each repeat
    if ((correct_key1 === key_resp_2.keys)) {
        feedback_text = "";
    } else {
        if ((correct_key1 !== key_resp_2.keys)) {
            feedback_text = "\u274c";
        }
    }
    
    text1.setText(feedback_text);
    // keep track of which components have finished
    feedback1Components = [];
    feedback1Components.push(text1);
    
    for (const thisComponent of feedback1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function feedback1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'feedback1'-------
    // get current time
    t = feedback1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text1* updates
    if (t >= 0.0 && text1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text1.tStart = t;  // (not accounting for frame time here)
      text1.frameNStart = frameN;  // exact frame index
      
      text1.setAutoDraw(true);
    }

    frameRemains = 0.0 + 1.0 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text1.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text1.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of feedback1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function feedback1RoutineEnd() {
  return async function () {
    //------Ending Routine 'feedback1'-------
    for (const thisComponent of feedback1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_9_allKeys;
var instruction2Components;
function instruction2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction2'-------
    t = 0;
    instruction2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_9.keys = undefined;
    key_resp_9.rt = undefined;
    _key_resp_9_allKeys = [];
    // keep track of which components have finished
    instruction2Components = [];
    instruction2Components.push(image2);
    instruction2Components.push(key_resp_9);
    
    for (const thisComponent of instruction2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction2'-------
    // get current time
    t = instruction2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image2* updates
    if (t >= 0.0 && image2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image2.tStart = t;  // (not accounting for frame time here)
      image2.frameNStart = frameN;  // exact frame index
      
      image2.setAutoDraw(true);
    }

    
    // *key_resp_9* updates
    if (t >= 0.0 && key_resp_9.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_9.tStart = t;  // (not accounting for frame time here)
      key_resp_9.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_9.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_9.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_9.clearEvents(); });
    }

    if (key_resp_9.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_9.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_9_allKeys = _key_resp_9_allKeys.concat(theseKeys);
      if (_key_resp_9_allKeys.length > 0) {
        key_resp_9.keys = _key_resp_9_allKeys[_key_resp_9_allKeys.length - 1].name;  // just the last key pressed
        key_resp_9.rt = _key_resp_9_allKeys[_key_resp_9_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction2RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction2'-------
    for (const thisComponent of instruction2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_9.keys', key_resp_9.keys);
    if (typeof key_resp_9.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_9.rt', key_resp_9.rt);
        routineTimer.reset();
        }
    
    key_resp_9.stop();
    // the Routine "instruction2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_3_allKeys;
var trialface1Components;
function trialface1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialface1'-------
    t = 0;
    trialface1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims2.setText(stims22);
    key_resp_3.keys = undefined;
    key_resp_3.rt = undefined;
    _key_resp_3_allKeys = [];
    // keep track of which components have finished
    trialface1Components = [];
    trialface1Components.push(fixation_2);
    trialface1Components.push(stims2);
    trialface1Components.push(key_resp_3);
    trialface1Components.push(malename);
    trialface1Components.push(femalename);
    
    for (const thisComponent of trialface1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function trialface1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialface1'-------
    // get current time
    t = trialface1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation_2* updates
    if (t >= 0.0 && fixation_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation_2.tStart = t;  // (not accounting for frame time here)
      fixation_2.frameNStart = frameN;  // exact frame index
      
      fixation_2.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation_2.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation_2.setAutoDraw(false);
    }
    
    // *stims2* updates
    if (t >= 0.5 && stims2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims2.tStart = t;  // (not accounting for frame time here)
      stims2.frameNStart = frameN;  // exact frame index
      
      stims2.setAutoDraw(true);
    }

    
    // *key_resp_3* updates
    if (t >= 0.5 && key_resp_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_3.tStart = t;  // (not accounting for frame time here)
      key_resp_3.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_3.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_3.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_3.clearEvents(); });
    }

    if (key_resp_3.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_3.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_3_allKeys = _key_resp_3_allKeys.concat(theseKeys);
      if (_key_resp_3_allKeys.length > 0) {
        key_resp_3.keys = _key_resp_3_allKeys[_key_resp_3_allKeys.length - 1].name;  // just the last key pressed
        key_resp_3.rt = _key_resp_3_allKeys[_key_resp_3_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_3.keys == correct_key2) {
            key_resp_3.corr = 1;
        } else {
            key_resp_3.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *malename* updates
    if (t >= 0.0 && malename.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      malename.tStart = t;  // (not accounting for frame time here)
      malename.frameNStart = frameN;  // exact frame index
      
      malename.setAutoDraw(true);
    }

    
    // *femalename* updates
    if (t >= 0.0 && femalename.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      femalename.tStart = t;  // (not accounting for frame time here)
      femalename.frameNStart = frameN;  // exact frame index
      
      femalename.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialface1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialface1RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialface1'-------
    for (const thisComponent of trialface1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_3.keys === undefined) {
      if (['None','none',undefined].includes(correct_key2)) {
         key_resp_3.corr = 1;  // correct non-response
      } else {
         key_resp_3.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_3.keys', key_resp_3.keys);
    psychoJS.experiment.addData('key_resp_3.corr', key_resp_3.corr);
    if (typeof key_resp_3.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_3.rt', key_resp_3.rt);
        routineTimer.reset();
        }
    
    key_resp_3.stop();
    // the Routine "trialface1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var restart_trial2Components;
function restart_trial2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'restart_trial2'-------
    t = 0;
    restart_trial2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    if ((key_resp_3.corr === 0)) {
        repeatLoop2.finished = false;
    } else {
        repeatLoop2.finished = true;
    }
    
    // keep track of which components have finished
    restart_trial2Components = [];
    
    for (const thisComponent of restart_trial2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function restart_trial2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'restart_trial2'-------
    // get current time
    t = restart_trial2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of restart_trial2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function restart_trial2RoutineEnd() {
  return async function () {
    //------Ending Routine 'restart_trial2'-------
    for (const thisComponent of restart_trial2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "restart_trial2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var feedback2Components;
function feedback2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'feedback2'-------
    t = 0;
    feedback2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(1.000000);
    // update component parameters for each repeat
    if ((correct_key2 === key_resp_3.keys)) {
        feedback_text = "";
    } else {
        if ((correct_key2 !== key_resp_3.keys)) {
            feedback_text = "\u274c";
        }
    }
    
    text2.setText(feedback_text);
    // keep track of which components have finished
    feedback2Components = [];
    feedback2Components.push(text2);
    
    for (const thisComponent of feedback2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function feedback2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'feedback2'-------
    // get current time
    t = feedback2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text2* updates
    if (t >= 0.0 && text2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text2.tStart = t;  // (not accounting for frame time here)
      text2.frameNStart = frameN;  // exact frame index
      
      text2.setAutoDraw(true);
    }

    frameRemains = 0.0 + 1.0 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text2.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text2.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of feedback2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function feedback2RoutineEnd() {
  return async function () {
    //------Ending Routine 'feedback2'-------
    for (const thisComponent of feedback2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_10_allKeys;
var instruction3Components;
function instruction3RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction3'-------
    t = 0;
    instruction3Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_10.keys = undefined;
    key_resp_10.rt = undefined;
    _key_resp_10_allKeys = [];
    // keep track of which components have finished
    instruction3Components = [];
    instruction3Components.push(image3);
    instruction3Components.push(key_resp_10);
    
    for (const thisComponent of instruction3Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction3RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction3'-------
    // get current time
    t = instruction3Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image3* updates
    if (t >= 0.0 && image3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image3.tStart = t;  // (not accounting for frame time here)
      image3.frameNStart = frameN;  // exact frame index
      
      image3.setAutoDraw(true);
    }

    
    // *key_resp_10* updates
    if (t >= 0.0 && key_resp_10.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_10.tStart = t;  // (not accounting for frame time here)
      key_resp_10.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_10.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_10.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_10.clearEvents(); });
    }

    if (key_resp_10.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_10.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_10_allKeys = _key_resp_10_allKeys.concat(theseKeys);
      if (_key_resp_10_allKeys.length > 0) {
        key_resp_10.keys = _key_resp_10_allKeys[_key_resp_10_allKeys.length - 1].name;  // just the last key pressed
        key_resp_10.rt = _key_resp_10_allKeys[_key_resp_10_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction3Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction3RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction3'-------
    for (const thisComponent of instruction3Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_10.keys', key_resp_10.keys);
    if (typeof key_resp_10.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_10.rt', key_resp_10.rt);
        routineTimer.reset();
        }
    
    key_resp_10.stop();
    // the Routine "instruction3" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_4_allKeys;
var trialsprac1Components;
function trialsprac1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialsprac1'-------
    t = 0;
    trialsprac1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims3.setText(stims33);
    key_resp_4.keys = undefined;
    key_resp_4.rt = undefined;
    _key_resp_4_allKeys = [];
    // keep track of which components have finished
    trialsprac1Components = [];
    trialsprac1Components.push(fixation3);
    trialsprac1Components.push(stims3);
    trialsprac1Components.push(key_resp_4);
    trialsprac1Components.push(mm1);
    trialsprac1Components.push(FF1);
    
    for (const thisComponent of trialsprac1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function trialsprac1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialsprac1'-------
    // get current time
    t = trialsprac1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation3* updates
    if (t >= 0.0 && fixation3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation3.tStart = t;  // (not accounting for frame time here)
      fixation3.frameNStart = frameN;  // exact frame index
      
      fixation3.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation3.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation3.setAutoDraw(false);
    }
    
    // *stims3* updates
    if (t >= 0.5 && stims3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims3.tStart = t;  // (not accounting for frame time here)
      stims3.frameNStart = frameN;  // exact frame index
      
      stims3.setAutoDraw(true);
    }

    
    // *key_resp_4* updates
    if (t >= 0.5 && key_resp_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_4.tStart = t;  // (not accounting for frame time here)
      key_resp_4.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_4.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_4.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_4.clearEvents(); });
    }

    if (key_resp_4.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_4.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_4_allKeys = _key_resp_4_allKeys.concat(theseKeys);
      if (_key_resp_4_allKeys.length > 0) {
        key_resp_4.keys = _key_resp_4_allKeys[_key_resp_4_allKeys.length - 1].name;  // just the last key pressed
        key_resp_4.rt = _key_resp_4_allKeys[_key_resp_4_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_4.keys == correct_key3) {
            key_resp_4.corr = 1;
        } else {
            key_resp_4.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *mm1* updates
    if (t >= 0.0 && mm1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      mm1.tStart = t;  // (not accounting for frame time here)
      mm1.frameNStart = frameN;  // exact frame index
      
      mm1.setAutoDraw(true);
    }

    
    // *FF1* updates
    if (t >= 0.0 && FF1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      FF1.tStart = t;  // (not accounting for frame time here)
      FF1.frameNStart = frameN;  // exact frame index
      
      FF1.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialsprac1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialsprac1RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialsprac1'-------
    for (const thisComponent of trialsprac1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_4.keys === undefined) {
      if (['None','none',undefined].includes(correct_key3)) {
         key_resp_4.corr = 1;  // correct non-response
      } else {
         key_resp_4.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_4.keys', key_resp_4.keys);
    psychoJS.experiment.addData('key_resp_4.corr', key_resp_4.corr);
    if (typeof key_resp_4.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_4.rt', key_resp_4.rt);
        routineTimer.reset();
        }
    
    key_resp_4.stop();
    // the Routine "trialsprac1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var restart_trial3Components;
function restart_trial3RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'restart_trial3'-------
    t = 0;
    restart_trial3Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    if ((key_resp_4.corr === 0)) {
        repeatLoop3.finished = false;
    } else {
        repeatLoop3.finished = true;
    }
    
    // keep track of which components have finished
    restart_trial3Components = [];
    
    for (const thisComponent of restart_trial3Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function restart_trial3RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'restart_trial3'-------
    // get current time
    t = restart_trial3Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of restart_trial3Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function restart_trial3RoutineEnd() {
  return async function () {
    //------Ending Routine 'restart_trial3'-------
    for (const thisComponent of restart_trial3Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "restart_trial3" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var feedback3Components;
function feedback3RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'feedback3'-------
    t = 0;
    feedback3Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(1.000000);
    // update component parameters for each repeat
    if ((correct_key3 === key_resp_4.keys)) {
        feedback_text = "";
    } else {
        if ((correct_key3 !== key_resp_4.keys)) {
            feedback_text = "\u274c";
        }
    }
    
    text2_2.setText(feedback_text);
    // keep track of which components have finished
    feedback3Components = [];
    feedback3Components.push(text2_2);
    
    for (const thisComponent of feedback3Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function feedback3RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'feedback3'-------
    // get current time
    t = feedback3Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text2_2* updates
    if (t >= 0.0 && text2_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text2_2.tStart = t;  // (not accounting for frame time here)
      text2_2.frameNStart = frameN;  // exact frame index
      
      text2_2.setAutoDraw(true);
    }

    frameRemains = 0.0 + 1.0 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text2_2.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text2_2.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of feedback3Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function feedback3RoutineEnd() {
  return async function () {
    //------Ending Routine 'feedback3'-------
    for (const thisComponent of feedback3Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_11_allKeys;
var instruction4Components;
function instruction4RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction4'-------
    t = 0;
    instruction4Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_11.keys = undefined;
    key_resp_11.rt = undefined;
    _key_resp_11_allKeys = [];
    // keep track of which components have finished
    instruction4Components = [];
    instruction4Components.push(image4);
    instruction4Components.push(key_resp_11);
    
    for (const thisComponent of instruction4Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction4RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction4'-------
    // get current time
    t = instruction4Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image4* updates
    if (t >= 0.0 && image4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image4.tStart = t;  // (not accounting for frame time here)
      image4.frameNStart = frameN;  // exact frame index
      
      image4.setAutoDraw(true);
    }

    
    // *key_resp_11* updates
    if (t >= 0.0 && key_resp_11.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_11.tStart = t;  // (not accounting for frame time here)
      key_resp_11.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_11.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_11.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_11.clearEvents(); });
    }

    if (key_resp_11.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_11.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_11_allKeys = _key_resp_11_allKeys.concat(theseKeys);
      if (_key_resp_11_allKeys.length > 0) {
        key_resp_11.keys = _key_resp_11_allKeys[_key_resp_11_allKeys.length - 1].name;  // just the last key pressed
        key_resp_11.rt = _key_resp_11_allKeys[_key_resp_11_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction4Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction4RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction4'-------
    for (const thisComponent of instruction4Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_11.keys', key_resp_11.keys);
    if (typeof key_resp_11.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_11.rt', key_resp_11.rt);
        routineTimer.reset();
        }
    
    key_resp_11.stop();
    // the Routine "instruction4" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_5_allKeys;
var trialszs1Components;
function trialszs1RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialszs1'-------
    t = 0;
    trialszs1Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims4.setText(stims44);
    key_resp_5.keys = undefined;
    key_resp_5.rt = undefined;
    _key_resp_5_allKeys = [];
    // keep track of which components have finished
    trialszs1Components = [];
    trialszs1Components.push(fixation4);
    trialszs1Components.push(stims4);
    trialszs1Components.push(key_resp_5);
    trialszs1Components.push(mm1_2);
    trialszs1Components.push(FF1_2);
    
    for (const thisComponent of trialszs1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function trialszs1RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialszs1'-------
    // get current time
    t = trialszs1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation4* updates
    if (t >= 0.0 && fixation4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation4.tStart = t;  // (not accounting for frame time here)
      fixation4.frameNStart = frameN;  // exact frame index
      
      fixation4.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation4.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation4.setAutoDraw(false);
    }
    
    // *stims4* updates
    if (t >= 0.5 && stims4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims4.tStart = t;  // (not accounting for frame time here)
      stims4.frameNStart = frameN;  // exact frame index
      
      stims4.setAutoDraw(true);
    }

    
    // *key_resp_5* updates
    if (t >= 0.5 && key_resp_5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_5.tStart = t;  // (not accounting for frame time here)
      key_resp_5.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_5.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_5.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_5.clearEvents(); });
    }

    if (key_resp_5.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_5.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_5_allKeys = _key_resp_5_allKeys.concat(theseKeys);
      if (_key_resp_5_allKeys.length > 0) {
        key_resp_5.keys = _key_resp_5_allKeys[_key_resp_5_allKeys.length - 1].name;  // just the last key pressed
        key_resp_5.rt = _key_resp_5_allKeys[_key_resp_5_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_5.keys == correct_key4) {
            key_resp_5.corr = 1;
        } else {
            key_resp_5.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *mm1_2* updates
    if (t >= 0.0 && mm1_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      mm1_2.tStart = t;  // (not accounting for frame time here)
      mm1_2.frameNStart = frameN;  // exact frame index
      
      mm1_2.setAutoDraw(true);
    }

    
    // *FF1_2* updates
    if (t >= 0.0 && FF1_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      FF1_2.tStart = t;  // (not accounting for frame time here)
      FF1_2.frameNStart = frameN;  // exact frame index
      
      FF1_2.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialszs1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialszs1RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialszs1'-------
    for (const thisComponent of trialszs1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_5.keys === undefined) {
      if (['None','none',undefined].includes(correct_key4)) {
         key_resp_5.corr = 1;  // correct non-response
      } else {
         key_resp_5.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_5.keys', key_resp_5.keys);
    psychoJS.experiment.addData('key_resp_5.corr', key_resp_5.corr);
    if (typeof key_resp_5.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_5.rt', key_resp_5.rt);
        routineTimer.reset();
        }
    
    key_resp_5.stop();
    // the Routine "trialszs1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_12_allKeys;
var instroduction5Components;
function instroduction5RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instroduction5'-------
    t = 0;
    instroduction5Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_12.keys = undefined;
    key_resp_12.rt = undefined;
    _key_resp_12_allKeys = [];
    // keep track of which components have finished
    instroduction5Components = [];
    instroduction5Components.push(image5);
    instroduction5Components.push(key_resp_12);
    
    for (const thisComponent of instroduction5Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instroduction5RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instroduction5'-------
    // get current time
    t = instroduction5Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image5* updates
    if (t >= 0.0 && image5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image5.tStart = t;  // (not accounting for frame time here)
      image5.frameNStart = frameN;  // exact frame index
      
      image5.setAutoDraw(true);
    }

    
    // *key_resp_12* updates
    if (t >= 0.0 && key_resp_12.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_12.tStart = t;  // (not accounting for frame time here)
      key_resp_12.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_12.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_12.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_12.clearEvents(); });
    }

    if (key_resp_12.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_12.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_12_allKeys = _key_resp_12_allKeys.concat(theseKeys);
      if (_key_resp_12_allKeys.length > 0) {
        key_resp_12.keys = _key_resp_12_allKeys[_key_resp_12_allKeys.length - 1].name;  // just the last key pressed
        key_resp_12.rt = _key_resp_12_allKeys[_key_resp_12_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instroduction5Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instroduction5RoutineEnd() {
  return async function () {
    //------Ending Routine 'instroduction5'-------
    for (const thisComponent of instroduction5Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_12.keys', key_resp_12.keys);
    if (typeof key_resp_12.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_12.rt', key_resp_12.rt);
        routineTimer.reset();
        }
    
    key_resp_12.stop();
    // the Routine "instroduction5" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_6_allKeys;
var reialsyundong2Components;
function reialsyundong2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'reialsyundong2'-------
    t = 0;
    reialsyundong2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims5.setText(stims55);
    key_resp_6.keys = undefined;
    key_resp_6.rt = undefined;
    _key_resp_6_allKeys = [];
    // keep track of which components have finished
    reialsyundong2Components = [];
    reialsyundong2Components.push(fixation5);
    reialsyundong2Components.push(stims5);
    reialsyundong2Components.push(key_resp_6);
    reialsyundong2Components.push(sportfemale2);
    reialsyundong2Components.push(sportmale2);
    
    for (const thisComponent of reialsyundong2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function reialsyundong2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'reialsyundong2'-------
    // get current time
    t = reialsyundong2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation5* updates
    if (t >= 0.0 && fixation5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation5.tStart = t;  // (not accounting for frame time here)
      fixation5.frameNStart = frameN;  // exact frame index
      
      fixation5.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation5.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation5.setAutoDraw(false);
    }
    
    // *stims5* updates
    if (t >= 0.5 && stims5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims5.tStart = t;  // (not accounting for frame time here)
      stims5.frameNStart = frameN;  // exact frame index
      
      stims5.setAutoDraw(true);
    }

    
    // *key_resp_6* updates
    if (t >= 0.5 && key_resp_6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_6.tStart = t;  // (not accounting for frame time here)
      key_resp_6.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_6.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_6.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_6.clearEvents(); });
    }

    if (key_resp_6.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_6.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_6_allKeys = _key_resp_6_allKeys.concat(theseKeys);
      if (_key_resp_6_allKeys.length > 0) {
        key_resp_6.keys = _key_resp_6_allKeys[_key_resp_6_allKeys.length - 1].name;  // just the last key pressed
        key_resp_6.rt = _key_resp_6_allKeys[_key_resp_6_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_6.keys == correct_key5) {
            key_resp_6.corr = 1;
        } else {
            key_resp_6.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *sportfemale2* updates
    if (t >= 0.0 && sportfemale2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sportfemale2.tStart = t;  // (not accounting for frame time here)
      sportfemale2.frameNStart = frameN;  // exact frame index
      
      sportfemale2.setAutoDraw(true);
    }

    
    // *sportmale2* updates
    if (t >= 0.0 && sportmale2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sportmale2.tStart = t;  // (not accounting for frame time here)
      sportmale2.frameNStart = frameN;  // exact frame index
      
      sportmale2.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of reialsyundong2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function reialsyundong2RoutineEnd() {
  return async function () {
    //------Ending Routine 'reialsyundong2'-------
    for (const thisComponent of reialsyundong2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_6.keys === undefined) {
      if (['None','none',undefined].includes(correct_key5)) {
         key_resp_6.corr = 1;  // correct non-response
      } else {
         key_resp_6.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_6.keys', key_resp_6.keys);
    psychoJS.experiment.addData('key_resp_6.corr', key_resp_6.corr);
    if (typeof key_resp_6.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_6.rt', key_resp_6.rt);
        routineTimer.reset();
        }
    
    key_resp_6.stop();
    // the Routine "reialsyundong2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var restart_5Components;
function restart_5RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'restart_5'-------
    t = 0;
    restart_5Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    if ((key_resp_6.corr === 0)) {
        repeatLoop5.finished = false;
    } else {
        repeatLoop5.finished = true;
    }
    
    // keep track of which components have finished
    restart_5Components = [];
    
    for (const thisComponent of restart_5Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function restart_5RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'restart_5'-------
    // get current time
    t = restart_5Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of restart_5Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function restart_5RoutineEnd() {
  return async function () {
    //------Ending Routine 'restart_5'-------
    for (const thisComponent of restart_5Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "restart_5" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var feedback5Components;
function feedback5RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'feedback5'-------
    t = 0;
    feedback5Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(1.000000);
    // update component parameters for each repeat
    if ((correct_key5 === key_resp_6.keys)) {
        feedback_text = "";
    } else {
        if ((correct_key5 !== key_resp_6.keys)) {
            feedback_text = "\u274c";
        }
    }
    
    text2_4.setText(feedback_text);
    // keep track of which components have finished
    feedback5Components = [];
    feedback5Components.push(text2_4);
    
    for (const thisComponent of feedback5Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function feedback5RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'feedback5'-------
    // get current time
    t = feedback5Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text2_4* updates
    if (t >= 0.0 && text2_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text2_4.tStart = t;  // (not accounting for frame time here)
      text2_4.frameNStart = frameN;  // exact frame index
      
      text2_4.setAutoDraw(true);
    }

    frameRemains = 0.0 + 1.0 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text2_4.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text2_4.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of feedback5Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function feedback5RoutineEnd() {
  return async function () {
    //------Ending Routine 'feedback5'-------
    for (const thisComponent of feedback5Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_13_allKeys;
var instruction6Components;
function instruction6RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction6'-------
    t = 0;
    instruction6Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_13.keys = undefined;
    key_resp_13.rt = undefined;
    _key_resp_13_allKeys = [];
    // keep track of which components have finished
    instruction6Components = [];
    instruction6Components.push(image6);
    instruction6Components.push(key_resp_13);
    
    for (const thisComponent of instruction6Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction6RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction6'-------
    // get current time
    t = instruction6Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image6* updates
    if (t >= 0.0 && image6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image6.tStart = t;  // (not accounting for frame time here)
      image6.frameNStart = frameN;  // exact frame index
      
      image6.setAutoDraw(true);
    }

    
    // *key_resp_13* updates
    if (t >= 0.0 && key_resp_13.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_13.tStart = t;  // (not accounting for frame time here)
      key_resp_13.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_13.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_13.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_13.clearEvents(); });
    }

    if (key_resp_13.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_13.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_13_allKeys = _key_resp_13_allKeys.concat(theseKeys);
      if (_key_resp_13_allKeys.length > 0) {
        key_resp_13.keys = _key_resp_13_allKeys[_key_resp_13_allKeys.length - 1].name;  // just the last key pressed
        key_resp_13.rt = _key_resp_13_allKeys[_key_resp_13_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction6Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction6RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction6'-------
    for (const thisComponent of instruction6Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_13.keys', key_resp_13.keys);
    if (typeof key_resp_13.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_13.rt', key_resp_13.rt);
        routineTimer.reset();
        }
    
    key_resp_13.stop();
    // the Routine "instruction6" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_7_allKeys;
var trialspr2Components;
function trialspr2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialspr2'-------
    t = 0;
    trialspr2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims6.setText(stims66);
    key_resp_7.keys = undefined;
    key_resp_7.rt = undefined;
    _key_resp_7_allKeys = [];
    // keep track of which components have finished
    trialspr2Components = [];
    trialspr2Components.push(fixation6);
    trialspr2Components.push(stims6);
    trialspr2Components.push(key_resp_7);
    trialspr2Components.push(FM);
    trialspr2Components.push(MF);
    
    for (const thisComponent of trialspr2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function trialspr2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialspr2'-------
    // get current time
    t = trialspr2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation6* updates
    if (t >= 0.0 && fixation6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation6.tStart = t;  // (not accounting for frame time here)
      fixation6.frameNStart = frameN;  // exact frame index
      
      fixation6.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation6.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation6.setAutoDraw(false);
    }
    
    // *stims6* updates
    if (t >= 0.5 && stims6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims6.tStart = t;  // (not accounting for frame time here)
      stims6.frameNStart = frameN;  // exact frame index
      
      stims6.setAutoDraw(true);
    }

    
    // *key_resp_7* updates
    if (t >= 0.5 && key_resp_7.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_7.tStart = t;  // (not accounting for frame time here)
      key_resp_7.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_7.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_7.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_7.clearEvents(); });
    }

    if (key_resp_7.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_7.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_7_allKeys = _key_resp_7_allKeys.concat(theseKeys);
      if (_key_resp_7_allKeys.length > 0) {
        key_resp_7.keys = _key_resp_7_allKeys[_key_resp_7_allKeys.length - 1].name;  // just the last key pressed
        key_resp_7.rt = _key_resp_7_allKeys[_key_resp_7_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_7.keys == correct_key6) {
            key_resp_7.corr = 1;
        } else {
            key_resp_7.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *FM* updates
    if (t >= 0.0 && FM.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      FM.tStart = t;  // (not accounting for frame time here)
      FM.frameNStart = frameN;  // exact frame index
      
      FM.setAutoDraw(true);
    }

    
    // *MF* updates
    if (t >= 0.0 && MF.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      MF.tStart = t;  // (not accounting for frame time here)
      MF.frameNStart = frameN;  // exact frame index
      
      MF.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialspr2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialspr2RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialspr2'-------
    for (const thisComponent of trialspr2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_7.keys === undefined) {
      if (['None','none',undefined].includes(correct_key6)) {
         key_resp_7.corr = 1;  // correct non-response
      } else {
         key_resp_7.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_7.keys', key_resp_7.keys);
    psychoJS.experiment.addData('key_resp_7.corr', key_resp_7.corr);
    if (typeof key_resp_7.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_7.rt', key_resp_7.rt);
        routineTimer.reset();
        }
    
    key_resp_7.stop();
    // the Routine "trialspr2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var restart_trial6Components;
function restart_trial6RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'restart_trial6'-------
    t = 0;
    restart_trial6Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    if ((key_resp_7.corr === 0)) {
        repeatLoop6.finished = false;
    } else {
        repeatLoop6.finished = true;
    }
    
    // keep track of which components have finished
    restart_trial6Components = [];
    
    for (const thisComponent of restart_trial6Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function restart_trial6RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'restart_trial6'-------
    // get current time
    t = restart_trial6Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of restart_trial6Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function restart_trial6RoutineEnd() {
  return async function () {
    //------Ending Routine 'restart_trial6'-------
    for (const thisComponent of restart_trial6Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "restart_trial6" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var feedback6Components;
function feedback6RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'feedback6'-------
    t = 0;
    feedback6Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(1.000000);
    // update component parameters for each repeat
    if ((correct_key6 === key_resp_7.keys)) {
        feedback_text = "";
    } else {
        if ((correct_key6 !== key_resp_7.keys)) {
            feedback_text = "\u274c";
        }
    }
    
    text2_5.setText(feedback_text);
    // keep track of which components have finished
    feedback6Components = [];
    feedback6Components.push(text2_5);
    
    for (const thisComponent of feedback6Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function feedback6RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'feedback6'-------
    // get current time
    t = feedback6Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text2_5* updates
    if (t >= 0.0 && text2_5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text2_5.tStart = t;  // (not accounting for frame time here)
      text2_5.frameNStart = frameN;  // exact frame index
      
      text2_5.setAutoDraw(true);
    }

    frameRemains = 0.0 + 1.0 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text2_5.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text2_5.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of feedback6Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function feedback6RoutineEnd() {
  return async function () {
    //------Ending Routine 'feedback6'-------
    for (const thisComponent of feedback6Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_14_allKeys;
var instruction7Components;
function instruction7RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'instruction7'-------
    t = 0;
    instruction7Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    key_resp_14.keys = undefined;
    key_resp_14.rt = undefined;
    _key_resp_14_allKeys = [];
    // keep track of which components have finished
    instruction7Components = [];
    instruction7Components.push(image7);
    instruction7Components.push(key_resp_14);
    
    for (const thisComponent of instruction7Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function instruction7RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'instruction7'-------
    // get current time
    t = instruction7Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *image7* updates
    if (t >= 0.0 && image7.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      image7.tStart = t;  // (not accounting for frame time here)
      image7.frameNStart = frameN;  // exact frame index
      
      image7.setAutoDraw(true);
    }

    
    // *key_resp_14* updates
    if (t >= 0.0 && key_resp_14.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_14.tStart = t;  // (not accounting for frame time here)
      key_resp_14.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_14.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_14.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_14.clearEvents(); });
    }

    if (key_resp_14.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_14.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_14_allKeys = _key_resp_14_allKeys.concat(theseKeys);
      if (_key_resp_14_allKeys.length > 0) {
        key_resp_14.keys = _key_resp_14_allKeys[_key_resp_14_allKeys.length - 1].name;  // just the last key pressed
        key_resp_14.rt = _key_resp_14_allKeys[_key_resp_14_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of instruction7Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function instruction7RoutineEnd() {
  return async function () {
    //------Ending Routine 'instruction7'-------
    for (const thisComponent of instruction7Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('key_resp_14.keys', key_resp_14.keys);
    if (typeof key_resp_14.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_14.rt', key_resp_14.rt);
        routineTimer.reset();
        }
    
    key_resp_14.stop();
    // the Routine "instruction7" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_8_allKeys;
var trialszs2Components;
function trialszs2RoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'trialszs2'-------
    t = 0;
    trialszs2Clock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    // update component parameters for each repeat
    stims7.setText(stims77);
    key_resp_8.keys = undefined;
    key_resp_8.rt = undefined;
    _key_resp_8_allKeys = [];
    // keep track of which components have finished
    trialszs2Components = [];
    trialszs2Components.push(fixation7);
    trialszs2Components.push(stims7);
    trialszs2Components.push(key_resp_8);
    trialszs2Components.push(FM_2);
    trialszs2Components.push(MF_2);
    
    for (const thisComponent of trialszs2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function trialszs2RoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'trialszs2'-------
    // get current time
    t = trialszs2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *fixation7* updates
    if (t >= 0.0 && fixation7.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      fixation7.tStart = t;  // (not accounting for frame time here)
      fixation7.frameNStart = frameN;  // exact frame index
      
      fixation7.setAutoDraw(true);
    }

    frameRemains = 0.0 + 0.5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (fixation7.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      fixation7.setAutoDraw(false);
    }
    
    // *stims7* updates
    if (t >= 0.5 && stims7.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      stims7.tStart = t;  // (not accounting for frame time here)
      stims7.frameNStart = frameN;  // exact frame index
      
      stims7.setAutoDraw(true);
    }

    
    // *key_resp_8* updates
    if (t >= 0.5 && key_resp_8.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_8.tStart = t;  // (not accounting for frame time here)
      key_resp_8.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_8.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_8.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_8.clearEvents(); });
    }

    if (key_resp_8.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_8.getKeys({keyList: ['e', 'i'], waitRelease: false});
      _key_resp_8_allKeys = _key_resp_8_allKeys.concat(theseKeys);
      if (_key_resp_8_allKeys.length > 0) {
        key_resp_8.keys = _key_resp_8_allKeys[_key_resp_8_allKeys.length - 1].name;  // just the last key pressed
        key_resp_8.rt = _key_resp_8_allKeys[_key_resp_8_allKeys.length - 1].rt;
        // was this correct?
        if (key_resp_8.keys == correct_key7) {
            key_resp_8.corr = 1;
        } else {
            key_resp_8.corr = 0;
        }
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *FM_2* updates
    if (t >= 0.0 && FM_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      FM_2.tStart = t;  // (not accounting for frame time here)
      FM_2.frameNStart = frameN;  // exact frame index
      
      FM_2.setAutoDraw(true);
    }

    
    // *MF_2* updates
    if (t >= 0.0 && MF_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      MF_2.tStart = t;  // (not accounting for frame time here)
      MF_2.frameNStart = frameN;  // exact frame index
      
      MF_2.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of trialszs2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function trialszs2RoutineEnd() {
  return async function () {
    //------Ending Routine 'trialszs2'-------
    for (const thisComponent of trialszs2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // was no response the correct answer?!
    if (key_resp_8.keys === undefined) {
      if (['None','none',undefined].includes(correct_key7)) {
         key_resp_8.corr = 1;  // correct non-response
      } else {
         key_resp_8.corr = 0;  // failed to respond (incorrectly)
      }
    }
    // store data for psychoJS.experiment (ExperimentHandler)
    psychoJS.experiment.addData('key_resp_8.keys', key_resp_8.keys);
    psychoJS.experiment.addData('key_resp_8.corr', key_resp_8.corr);
    if (typeof key_resp_8.keys !== 'undefined') {  // we had a response
        psychoJS.experiment.addData('key_resp_8.rt', key_resp_8.rt);
        routineTimer.reset();
        }
    
    key_resp_8.stop();
    // the Routine "trialszs2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var thanksComponents;
function thanksRoutineBegin(snapshot) {
  return async function () {
    TrialHandler.fromSnapshot(snapshot); // ensure that .thisN vals are up to date
    
    //------Prepare to start Routine 'thanks'-------
    t = 0;
    thanksClock.reset(); // clock
    frameN = -1;
    continueRoutine = true; // until we're told otherwise
    routineTimer.add(3.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    thanksComponents = [];
    thanksComponents.push(imageend);
    
    for (const thisComponent of thanksComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    return Scheduler.Event.NEXT;
  }
}


function thanksRoutineEachFrame() {
  return async function () {
    //------Loop for each frame of Routine 'thanks'-------
    // get current time
    t = thanksClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *imageend* updates
    if (t >= 0.0 && imageend.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      imageend.tStart = t;  // (not accounting for frame time here)
      imageend.frameNStart = frameN;  // exact frame index
      
      imageend.setAutoDraw(true);
    }

    frameRemains = 0.0 + 3 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (imageend.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      imageend.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of thanksComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function thanksRoutineEnd() {
  return async function () {
    //------Ending Routine 'thanks'-------
    for (const thisComponent of thanksComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


function endLoopIteration(scheduler, snapshot) {
  // ------Prepare for next entry------
  return async function () {
    if (typeof snapshot !== 'undefined') {
      // ------Check if user ended loop early------
      if (snapshot.finished) {
        // Check for and save orphaned data
        if (psychoJS.experiment.isEntryEmpty()) {
          psychoJS.experiment.nextEntry(snapshot);
        }
        scheduler.stop();
      } else {
        const thisTrial = snapshot.getCurrentTrial();
        if (typeof thisTrial === 'undefined' || !('isTrials' in thisTrial) || thisTrial.isTrials) {
          psychoJS.experiment.nextEntry(snapshot);
        }
      }
    return Scheduler.Event.NEXT;
    }
  };
}


function importConditions(currentLoop) {
  return async function () {
    psychoJS.importAttributes(currentLoop.getCurrentTrial());
    return Scheduler.Event.NEXT;
    };
}


async function quitPsychoJS(message, isCompleted) {
  // Check for and save orphaned data
  if (psychoJS.experiment.isEntryEmpty()) {
    psychoJS.experiment.nextEntry();
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  psychoJS.window.close();
  psychoJS.quit({message: message, isCompleted: isCompleted});
  
  return Scheduler.Event.QUIT;
}
